from torch import nn
from hydra.utils import instantiate

class Resnet(nn.Module):
    def __init__(self, num_classes, resnet):
        super().__init__()
        self.resnet = resnet
        self.resnet.fc = nn.Linear(self.resnet.fc.in_features, num_classes)
    def forward(self, x):
        return self.resnet(x)